; trace.asm - public domain
; by robert sawdey 10/03/84
; compuserve id  73256,3131
;
*      =     $c000
screen =     $0400
color  =     $d800
;
       jmp   toggle
       jmp   trace
;
on     .word *-3
off    .word $ea31
prev   .word $ffff
num    .word $ffff
divtbl .dbyt $10e8, $640a
       .dbyt $2703, $0000
;
toggle sei           ;swap vector
       ldx $0314
       ldy $0315
       txa
       cmp on        ;trace = on?
       beq tracof
tracon stx off       ;turn on
       sty off+1
       ldx on
       ldy on+1
       jmp comm
tracof ldx off       ;turn off
       ldy off+1
comm   stx $0314
       sty $0315
       cli
       rts
;
trace  pha           ;basic trace
       txa
       pha           ;preserve
       tya           ;registers
       pha
       cld
       ldx $39
       ldy $3a
       txa
       cmp prev      ;new line?
       beq quit
       stx num
       stx prev
       sty num+1
       sty prev+1
       ldx #$00    ;move old lines
lin1   lda screen+114,x
       sta screen+74,x
       inx
       cpx #$05
       bne lin1
       ldx #$00
lin2   lda screen+154,x
       sta screen+114,x
       inx
       cpx #$05
     	 bne lin2
       ldx #$00
       lda $0286
map    sta color+154,x
       sta color+114,x
       sta color+74,x
       inx
       cpx #$05
       bne map
       ldy #$00 ;hex to dec & prt
digit  ldx #$00
loop   lda num         ;10m, 1m,
       sec             ;100, 10
       sbc divtbl,y    ;divides
       sta num
       lda num+1
       sbc divtbl+4,y
       bcc neg
       sta num+1
       inx             ;dec# +1
       jmp loop
neg    lda num
       adc divtbl,y    ;restore
       sta num         ;overdr	 t
       txa
       ora #$b0        ;make ascii
       sta screen+154,y
       iny
       cpy #$04
       bne digit
       lda num         ;do units
       ora #$b0
       sta screen+154,y
quit   pla             ;restore
       tay             ;registers
       pla
       tax
       pla
       jmp (off)
end
